# API Kurulum Rehberi

## 1. API URL Yapılandırması

`src/config/api.js` dosyasını açın ve API URL'ini güncelleyin:

```javascript
export const API_BASE_URL = 'http://193.111.77.77/database/api';
```

**ÖNEMLİ:** 
- HTTP kullanıyorsanız: `http://193.111.77.77/database/api`
- HTTPS kullanıyorsanız: `https://yourdomain.com/database/api`
- Eğer domain kullanıyorsanız, domain adresinizi yazın

## 2. PHP Dosyalarını Yükleme

1. `database` klasörünün tamamını sunucunuza yükleyin
2. Yol örneği: `public_html/database/` veya `www/database/`
3. Dosya yapısı şöyle olmalı:
   ```
   database/
   ├── config.php
   ├── api/
   │   ├── register.php
   │   ├── login.php
   │   └── sync.php
   └── schema.sql
   ```

## 3. Veritabanı Tablolarını Oluşturma

1. phpMyAdmin'e giriş yapın
2. `bayrakt1_proje1kisisel` veritabanını seçin
3. `database/schema.sql` dosyasındaki SQL kodlarını çalıştırın

## 4. Test

API'nin çalışıp çalışmadığını test etmek için:

1. Tarayıcıda şu URL'yi açın:
   `http://193.111.77.77/database/api/register.php`
   
2. Eğer JSON hatası görüyorsanız (örneğin "Sadece POST isteği kabul edilir"), API çalışıyor demektir.

## 5. Sorun Giderme

### "Network request failed" Hatası
- İnternet bağlantınızı kontrol edin
- API URL'inin doğru olduğundan emin olun
- Sunucunun çalıştığından emin olun
- CORS ayarlarını kontrol edin (PHP dosyalarında zaten var)

### "API URL yapılandırılmamış" Hatası
- `src/config/api.js` dosyasını açın
- `API_BASE_URL` değerini güncelleyin

### PHP Hataları
- PHP error log'larını kontrol edin
- `config.php` dosyasındaki veritabanı bilgilerini kontrol edin
- PHP versiyonunun 7.4+ olduğundan emin olun

## 6. Güvenlik

- Mümkünse HTTPS kullanın
- API endpoint'lerini rate limiting ile koruyun
- SQL injection koruması zaten var (prepared statements)

