# MySQL Veritabanı Kurulum Rehberi

## ⚠️ ÖNEMLİ: Domain Değiştirme

API URL'ini değiştirmek için `src/config/api.js` dosyasını düzenleyin:

```javascript
export const API_BASE_URL = 'https://bayraktarlavas.com.tr/database/api';
```

**Mevcut Domain:** `https://bayraktarlavas.com.tr/database/api`

Domain değiştirmek isterseniz:
1. `src/config/api.js` dosyasını açın
2. `API_BASE_URL` değerini yeni domain'inizle değiştirin
3. Uygulamayı yeniden başlatın

## 1. Veritabanı Oluşturma

1. phpMyAdmin veya MySQL komut satırına giriş yapın
2. `database/schema.sql` dosyasındaki SQL kodlarını çalıştırın
3. Tüm tablolar otomatik olarak oluşturulacaktır

## 2. PHP Dosyalarını Sunucuya Yükleme

1. `database` klasörünün tamamını sunucunuza yükleyin
2. Yol: `public_html/database/` veya `www/database/` gibi

## 3. API URL Yapılandırması

`src/config/api.js` dosyasındaki `API_BASE_URL` değerini güncelleyin:

```javascript
export const API_BASE_URL = 'https://yourdomain.com/database/api';
```

Örnek:
- `http://193.111.77.77/database/api` (HTTP için)
- `https://yourdomain.com/database/api` (HTTPS için)

## 4. Veritabanı Bağlantı Bilgileri

`database/config.php` dosyasında bağlantı bilgileri zaten ayarlanmış:
- Sunucu: 193.111.77.77
- Kullanıcı: bayrakt1_lavas
- Şifre: ]zXd%n-bP,QXL.~s
- Veritabanı: bayrakt1_proje1kisisel

## 5. API Endpoints

- **POST** `/database/api/register.php` - Kullanıcı kaydı
- **POST** `/database/api/login.php` - Kullanıcı girişi
- **POST** `/database/api/sync.php` - Veri senkronizasyonu

## 6. Güvenlik Notları

- PHP dosyalarınızı HTTPS üzerinden servis edin
- Sunucunuzda SSL sertifikası kurulu olmalı
- API endpoint'lerini rate limiting ile koruyun
- SQL injection koruması için prepared statements kullanılıyor

## 7. PHP JSON Extension Hatası

Eğer "Call to undefined function json_encode()" hatası alıyorsanız:

1. Sunucunuzda PHP JSON extension'ının yüklü olduğundan emin olun
2. Hosting panelinizden PHP extension'larını kontrol edin
3. Gerekirse hosting sağlayıcınızla iletişime geçin

**Test:** `http://bayraktarlavas.com.tr/database/api/test.php` adresini açarak kontrol edin.

## 8. Test

1. Uygulamayı çalıştırın
2. Kayıt ol ekranından yeni bir hesap oluşturun
3. Giriş yapın
4. Verilerin MySQL'de kaydedildiğini kontrol edin

