# PHP JSON Extension Hatası Çözümü

## Sorun

Sunucunuzda PHP JSON extension yüklü değil. Bu yüzden `json_encode()` ve `json_decode()` fonksiyonları çalışmıyor.

## Hata Mesajı

```
Fatal error: Call to undefined function json_decode() in /home/bayrakt1/public_html/database/config.php:34
```

## ⚠️ ACİL ÇÖZÜM ADIMLARI

### Adım 1: Test Dosyasını Çalıştırın

Önce durumu kontrol edin:

```
https://bayraktarlavas.com.tr/database/check_php_extensions.php
```

veya

```
https://bayraktarlavas.com.tr/database/phpinfo.php
```

### Adım 2: .htaccess Dosyasını Deneyin

`database/.htaccess` dosyasını sunucuya yükleyin. Bazı sunucularda bu dosya JSON extension'ını aktifleştirebilir.

### Adım 3: Hosting Panelinden Kontrol

1. Hosting panelinize giriş yapın (cPanel, Plesk, vb.)
2. PHP ayarlarına gidin
3. "PHP Extensions" veya "Select PHP Version" bölümüne gidin
4. **JSON** extension'ının aktif olduğundan emin olun

### 2. php.ini Dosyası ile Aktifleştirme

Eğer hosting panelinden yapamıyorsanız, `php.ini` dosyasına şunu ekleyin:

```ini
extension=json
```

Veya `.htaccess` dosyasına (public_html klasörüne):

```apache
php_flag json.enable On
```

### 3. Hosting Sağlayıcınızla İletişime Geçin

Eğer yukarıdaki yöntemler işe yaramazsa, hosting sağlayıcınızla iletişime geçin ve şunu söyleyin:

> "PHP JSON extension'ını aktifleştirmem gerekiyor. `json_encode()` ve `json_decode()` fonksiyonlarını kullanabilmem için JSON extension'ının yüklü olması gerekiyor."

### 4. Test Dosyası

`database/check_php_extensions.php` dosyasını sunucuya yükleyin ve tarayıcıda açın:

```
https://bayraktarlavas.com.tr/database/check_php_extensions.php
```

Bu dosya hangi extension'ların yüklü olduğunu gösterecektir.

## Geçici Çözüm (Önerilmez)

Eğer JSON extension'ını aktifleştiremiyorsanız, alternatif bir JSON kütüphanesi kullanabilirsiniz, ancak bu **kesinlikle önerilmez**. En iyi çözüm JSON extension'ını aktifleştirmektir.

## Kontrol

JSON extension aktif olduktan sonra, test dosyasını çalıştırın:

```
https://bayraktarlavas.com.tr/database/api/test.php
```

Eğer JSON yanıtı görüyorsanız, sorun çözülmüştür.

