# Veritabanı Tabloları Kurulum Rehberi

## ⚠️ ÖNEMLİ: 500 Hatası Çözümü

500 hatası alıyorsanız, muhtemelen veritabanı tabloları oluşturulmamıştır.

## Adım 1: Tabloları Kontrol Edin

Tarayıcıda şu adresi açın:
```
https://bayraktarlavas.com.tr/database/api/check_tables.php
```

Bu dosya hangi tabloların mevcut olduğunu gösterecektir.

## Adım 2: Tabloları Oluşturun

1. phpMyAdmin'e giriş yapın
2. `bayrakt1_proje1kisisel` veritabanını seçin
3. "SQL" sekmesine gidin
4. `database/schema.sql` dosyasındaki **TÜM** SQL kodlarını kopyalayın
5. Yapıştırın ve çalıştırın

## Gerekli Tablolar

Aşağıdaki tablolar oluşturulmalıdır:

1. ✅ `users` - Kullanıcılar
2. ✅ `user_profiles` - Kullanıcı profilleri
3. ✅ `cycle_history` - Adet döngü geçmişi
4. ✅ `weight_history` - Kilo takibi
5. ✅ `user_settings` - Kullanıcı ayarları
6. ✅ `device_sync` - Cihaz senkronizasyonu
7. ⚠️ **`friendships`** - Arkadaşlık tablosu (YENİ)
8. ⚠️ **`messages`** - Mesajlaşma tablosu (YENİ)

## Yeni Tablolar İçin SQL

Eğer sadece yeni tabloları eklemek istiyorsanız, `database/schema.sql` dosyasının sonundaki şu kısmı çalıştırın:

```sql
-- Arkadaşlık tablosu
CREATE TABLE IF NOT EXISTS `friendships` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `user_id` INT(11) NOT NULL COMMENT 'Arkadaşlık isteği gönderen',
  `friend_id` INT(11) NOT NULL COMMENT 'Arkadaşlık isteği alan',
  `status` ENUM('pending', 'accepted', 'blocked') DEFAULT 'pending' COMMENT 'pending: bekliyor, accepted: kabul edildi, blocked: engellendi',
  `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_friendship` (`user_id`, `friend_id`),
  FOREIGN KEY (`user_id`) REFERENCES `users`(`id`) ON DELETE CASCADE,
  FOREIGN KEY (`friend_id`) REFERENCES `users`(`id`) ON DELETE CASCADE,
  INDEX `idx_user_id` (`user_id`),
  INDEX `idx_friend_id` (`friend_id`),
  INDEX `idx_status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Mesajlaşma tablosu
CREATE TABLE IF NOT EXISTS `messages` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `sender_id` INT(11) NOT NULL COMMENT 'Mesaj gönderen kullanıcı',
  `receiver_id` INT(11) NOT NULL COMMENT 'Mesaj alan kullanıcı',
  `message` TEXT NOT NULL,
  `is_read` TINYINT(1) DEFAULT 0 COMMENT '0: okunmadı, 1: okundu',
  `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  FOREIGN KEY (`sender_id`) REFERENCES `users`(`id`) ON DELETE CASCADE,
  FOREIGN KEY (`receiver_id`) REFERENCES `users`(`id`) ON DELETE CASCADE,
  INDEX `idx_sender_id` (`sender_id`),
  INDEX `idx_receiver_id` (`receiver_id`),
  INDEX `idx_created_at` (`created_at`),
  INDEX `idx_is_read` (`is_read`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
```

## Kontrol

Tablolar oluşturulduktan sonra tekrar test edin:
```
https://bayraktarlavas.com.tr/database/api/check_tables.php
```

Tüm tablolar "exists: true" göstermelidir.

