# API URL Test Rehberi

## 404 Hatası Çözümü

404 hatası alıyorsanız, PHP dosyalarının doğru yerde olup olmadığını kontrol edin.

## 1. Test Dosyalarını Kullanın

### Test 1: API Test
Tarayıcıda şu URL'yi açın:
```
http://193.111.77.77/database/api/test.php
```

Eğer JSON yanıtı görüyorsanız, API çalışıyor demektir.

### Test 2: Veritabanı Bağlantısı
```
http://193.111.77.77/database/test_connection.php
```

## 2. Olası URL Yapıları

Sunucunuzun yapısına göre URL farklı olabilir:

### Seçenek 1: public_html altında
```
http://193.111.77.77/database/api/register.php
```

### Seçenek 2: www altında
```
http://193.111.77.77/www/database/api/register.php
```

### Seçenek 3: Doğrudan domain altında
```
http://yourdomain.com/database/api/register.php
```

### Seçenek 4: Alt domain
```
http://api.yourdomain.com/register.php
```

## 3. src/config/api.js Güncelleme

Test dosyaları çalıştıktan sonra, doğru URL'yi `src/config/api.js` dosyasına yazın:

```javascript
// Örnek 1
export const API_BASE_URL = 'http://193.111.77.77/database/api';

// Örnek 2
export const API_BASE_URL = 'http://193.111.77.77/www/database/api';

// Örnek 3
export const API_BASE_URL = 'https://yourdomain.com/database/api';
```

## 4. Dosya Yapısı Kontrolü

Sunucunuzda dosya yapısı şöyle olmalı:

```
public_html/ (veya www/)
  └── database/
      ├── config.php
      ├── test_connection.php
      └── api/
          ├── test.php
          ├── register.php
          ├── login.php
          └── sync.php
```

## 5. .htaccess Dosyası (Opsiyonel)

Eğer Apache kullanıyorsanız, `database/api/` klasörüne `.htaccess` dosyası ekleyebilirsiniz:

```apache
<IfModule mod_headers.c>
    Header set Access-Control-Allow-Origin "*"
    Header set Access-Control-Allow-Methods "GET, POST, PUT, DELETE, OPTIONS"
    Header set Access-Control-Allow-Headers "Content-Type, Authorization"
</IfModule>
```

## 6. Sorun Giderme

### 404 Hatası
- Dosyaların sunucuda doğru yerde olduğundan emin olun
- Dosya izinlerini kontrol edin (755 veya 644)
- Sunucu log'larını kontrol edin

### 500 Hatası
- PHP hata log'larını kontrol edin
- `config.php` dosyasındaki veritabanı bilgilerini kontrol edin
- PHP versiyonunun 7.4+ olduğundan emin olun

### CORS Hatası
- `config.php` dosyasındaki CORS header'larını kontrol edin
- `.htaccess` dosyası ekleyin (yukarıdaki örnek)

