<?php
// Veritabanı tablolarını kontrol et
try {
    require_once '../config.php';
} catch (Exception $e) {
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode([
        'success' => false,
        'message' => 'Config yükleme hatası: ' . $e->getMessage()
    ], JSON_UNESCAPED_UNICODE);
    exit();
}

header('Content-Type: application/json; charset=utf-8');

$tables = ['users', 'friendships', 'messages'];
$results = [];

foreach ($tables as $table) {
    $result = $conn->query("SHOW TABLES LIKE '$table'");
    $exists = $result->num_rows > 0;
    
    if ($exists) {
        // Tablo var, sütunları kontrol et
        $columns_result = $conn->query("SHOW COLUMNS FROM $table");
        $columns = [];
        while ($row = $columns_result->fetch_assoc()) {
            $columns[] = $row['Field'];
        }
        $results[$table] = [
            'exists' => true,
            'columns' => $columns
        ];
    } else {
        $results[$table] = [
            'exists' => false,
            'message' => 'Tablo bulunamadı. Lütfen database/schema.sql dosyasını çalıştırın.'
        ];
    }
}

echo json_encode([
    'success' => true,
    'tables' => $results
], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);

$conn->close();
?>

