<?php
// Hata yakalama için try-catch
try {
    require_once '../config.php';
} catch (Exception $e) {
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode([
        'success' => false,
        'message' => 'Config yükleme hatası: ' . $e->getMessage()
    ], JSON_UNESCAPED_UNICODE);
    exit();
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    sendResponse(false, 'Sadece POST isteği kabul edilir');
}

$input = getJsonInput();
$username = sanitize($input['username'] ?? '');
$password = $input['password'] ?? '';
$device_id = sanitize($input['device_id'] ?? '');

if (empty($username) || empty($password)) {
    sendResponse(false, 'Kullanıcı adı ve şifre gereklidir');
}

// Kullanıcıyı bul (username veya email ile)
$stmt = $conn->prepare("SELECT id, username, email, password_hash, gender FROM users WHERE username = ? OR email = ?");
$stmt->bind_param("ss", $username, $username);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    sendResponse(false, 'Kullanıcı adı veya şifre hatalı');
}

$user = $result->fetch_assoc();

// Şifre kontrolü
if (!password_verify($password, $user['password_hash'])) {
    sendResponse(false, 'Kullanıcı adı veya şifre hatalı');
}

// Cihaz kaydı güncelle veya oluştur
$push_token = sanitize($input['push_token'] ?? '');
if (!empty($device_id)) {
    $device_check = $conn->prepare("SELECT id FROM device_sync WHERE user_id = ? AND device_id = ?");
    $device_check->bind_param("is", $user['id'], $device_id);
    $device_check->execute();
    $device_result = $device_check->get_result();
    
    if ($device_result->num_rows > 0) {
        // Cihaz zaten kayıtlı, son senkronizasyon zamanını ve push token'ı güncelle
        if (!empty($push_token)) {
            $device_update = $conn->prepare("UPDATE device_sync SET last_sync_at = NOW(), push_token = ? WHERE user_id = ? AND device_id = ?");
            $device_update->bind_param("sis", $push_token, $user['id'], $device_id);
        } else {
            $device_update = $conn->prepare("UPDATE device_sync SET last_sync_at = NOW() WHERE user_id = ? AND device_id = ?");
            $device_update->bind_param("is", $user['id'], $device_id);
        }
        $device_update->execute();
    } else {
        // Yeni cihaz kaydı
        $device_insert = $conn->prepare("INSERT INTO device_sync (user_id, device_id, push_token, last_sync_at) VALUES (?, ?, ?, NOW())");
        $device_insert->bind_param("iss", $user['id'], $device_id, $push_token);
        $device_insert->execute();
    }
}

// Kullanıcı ayarlarını getir
$settings_stmt = $conn->prepare("SELECT * FROM user_settings WHERE user_id = ?");
$settings_stmt->bind_param("i", $user['id']);
$settings_stmt->execute();
$settings_result = $settings_stmt->get_result();
$settings = $settings_result->fetch_assoc();

// Profil bilgilerini getir
$profile_stmt = $conn->prepare("SELECT * FROM user_profiles WHERE user_id = ?");
$profile_stmt->bind_param("i", $user['id']);
$profile_stmt->execute();
$profile_result = $profile_stmt->get_result();
$profile = $profile_result->fetch_assoc();

sendResponse(true, 'Giriş başarılı', [
    'user_id' => $user['id'],
    'username' => $user['username'],
    'email' => $user['email'],
    'gender' => $user['gender'],
    'settings' => $settings,
    'profile' => $profile
]);

$stmt->close();
$conn->close();
?>

