<?php
// Expo Push Notification gönderme fonksiyonu
function sendExpoPushNotification($pushTokens, $title, $body, $data = []) {
    if (empty($pushTokens) || !is_array($pushTokens)) {
        return false;
    }
    
    // Geçerli token'ları filtrele
    $validTokens = array_filter($pushTokens, function($token) {
        return !empty($token) && (strpos($token, 'ExponentPushToken[') === 0 || strpos($token, 'ExpoPushToken[') === 0);
    });
    
    if (empty($validTokens)) {
        return false;
    }
    
    $messages = [];
    foreach ($validTokens as $token) {
        $messages[] = [
            'to' => $token,
            'sound' => 'default',
            'title' => $title,
            'body' => $body,
            'data' => $data,
            'badge' => 1,
        ];
    }
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, 'https://exp.host/--/api/v2/push/send');
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Accept: application/json',
        'Content-Type: application/json',
    ]);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($messages));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($httpCode === 200) {
        return true;
    }
    
    return false;
}
?>

