<?php
// Hata yakalama için try-catch
try {
    require_once '../config.php';
} catch (Exception $e) {
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode([
        'success' => false,
        'message' => 'Config yükleme hatası: ' . $e->getMessage()
    ], JSON_UNESCAPED_UNICODE);
    exit();
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    sendResponse(false, 'Sadece POST isteği kabul edilir');
}

$input = getJsonInput();
$username = sanitize($input['username'] ?? '');
$email = sanitize($input['email'] ?? '');
$password = $input['password'] ?? '';
$gender = sanitize($input['gender'] ?? '');
$device_id = sanitize($input['device_id'] ?? '');

// Validasyon
if (empty($username) || empty($email) || empty($password)) {
    sendResponse(false, 'Kullanıcı adı, email ve şifre gereklidir');
}

// Cinsiyet validasyonu
if (!empty($gender) && !in_array($gender, ['male', 'female'])) {
    sendResponse(false, 'Geçersiz cinsiyet değeri');
}

if (strlen($password) < 6) {
    sendResponse(false, 'Şifre en az 6 karakter olmalıdır');
}

if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    sendResponse(false, 'Geçerli bir email adresi giriniz');
}

// Kullanıcı adı ve email kontrolü
$check = $conn->prepare("SELECT id FROM users WHERE username = ? OR email = ?");
$check->bind_param("ss", $username, $email);
$check->execute();
$result = $check->get_result();

if ($result->num_rows > 0) {
    sendResponse(false, 'Bu kullanıcı adı veya email zaten kullanılıyor');
}

// Şifreyi hashle
$password_hash = password_hash($password, PASSWORD_DEFAULT);

// Kullanıcıyı kaydet
$gender_value = !empty($gender) ? $gender : null;
$stmt = $conn->prepare("INSERT INTO users (username, email, password_hash, gender, device_id) VALUES (?, ?, ?, ?, ?)");
$stmt->bind_param("sssss", $username, $email, $password_hash, $gender_value, $device_id);

if ($stmt->execute()) {
    $user_id = $conn->insert_id;
    
    // Varsayılan ayarları oluştur (renk teması pembe olarak başlat)
    $settings_stmt = $conn->prepare("INSERT INTO user_settings (user_id, color_theme) VALUES (?, 'pink')");
    $settings_stmt->bind_param("i", $user_id);
    $settings_stmt->execute();
    
    // Cihaz kaydı
    if (!empty($device_id)) {
        $device_stmt = $conn->prepare("INSERT INTO device_sync (user_id, device_id, last_sync_at) VALUES (?, ?, NOW())");
        $device_stmt->bind_param("is", $user_id, $device_id);
        $device_stmt->execute();
    }
    
    sendResponse(true, 'Kayıt başarılı', [
        'user_id' => $user_id,
        'username' => $username,
        'email' => $email
    ]);
} else {
    sendResponse(false, 'Kayıt başarısız: ' . $conn->error);
}

$stmt->close();
$conn->close();
?>

