<?php
// Hata yakalama için try-catch
try {
    require_once '../config.php';
} catch (Exception $e) {
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode([
        'success' => false,
        'message' => 'Config yükleme hatası: ' . $e->getMessage()
    ], JSON_UNESCAPED_UNICODE);
    exit();
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    sendResponse(false, 'Sadece POST isteği kabul edilir');
}

$input = getJsonInput();
$user_id = intval($input['user_id'] ?? 0);
$device_id = sanitize($input['device_id'] ?? '');
$push_token = sanitize($input['push_token'] ?? '');

if (empty($user_id) || empty($device_id)) {
    sendResponse(false, 'Kullanıcı ID ve cihaz ID gereklidir');
}

// push_token kolonunun varlığını kontrol et, yoksa ekle
try {
    $check_column = $conn->query("SHOW COLUMNS FROM device_sync LIKE 'push_token'");
    if ($check_column->num_rows === 0) {
        // Kolon yoksa ekle
        $conn->query("ALTER TABLE `device_sync` ADD COLUMN `push_token` VARCHAR(500) NULL COMMENT 'Expo push notification token' AFTER `device_name`");
        $conn->query("ALTER TABLE `device_sync` ADD INDEX `idx_push_token` (`push_token`)");
    }
} catch (Exception $e) {
    // Kolon zaten varsa veya başka bir hata varsa devam et
}

// Cihaz kaydını bul ve push token'ı güncelle
$device_check = $conn->prepare("SELECT id FROM device_sync WHERE user_id = ? AND device_id = ?");
if (!$device_check) {
    sendResponse(false, 'Veritabanı hatası: ' . $conn->error);
}
$device_check->bind_param("is", $user_id, $device_id);
if (!$device_check->execute()) {
    sendResponse(false, 'Cihaz kontrolü hatası: ' . $device_check->error);
}
$device_result = $device_check->get_result();

if ($device_result->num_rows > 0) {
    // Cihaz zaten kayıtlı, push token'ı güncelle
    if (!empty($push_token)) {
        $device_update = $conn->prepare("UPDATE device_sync SET push_token = ?, last_sync_at = NOW() WHERE user_id = ? AND device_id = ?");
        if (!$device_update) {
            sendResponse(false, 'Veritabanı hatası: ' . $conn->error);
        }
        $device_update->bind_param("sis", $push_token, $user_id, $device_id);
        if (!$device_update->execute()) {
            sendResponse(false, 'Güncelleme hatası: ' . $device_update->error);
        }
    } else {
        // Push token boşsa, sadece last_sync_at güncelle
        $device_update = $conn->prepare("UPDATE device_sync SET last_sync_at = NOW() WHERE user_id = ? AND device_id = ?");
        if (!$device_update) {
            sendResponse(false, 'Veritabanı hatası: ' . $conn->error);
        }
        $device_update->bind_param("is", $user_id, $device_id);
        if (!$device_update->execute()) {
            sendResponse(false, 'Güncelleme hatası: ' . $device_update->error);
        }
    }
    sendResponse(true, 'Push token güncellendi');
} else {
    // Yeni cihaz kaydı oluştur
    $device_insert = $conn->prepare("INSERT INTO device_sync (user_id, device_id, push_token, last_sync_at) VALUES (?, ?, ?, NOW())");
    if (!$device_insert) {
        sendResponse(false, 'Veritabanı hatası: ' . $conn->error);
    }
    $device_insert->bind_param("iss", $user_id, $device_id, $push_token);
    if (!$device_insert->execute()) {
        sendResponse(false, 'Kayıt hatası: ' . $device_insert->error);
    }
    sendResponse(true, 'Cihaz kaydedildi');
}

$conn->close();
?>

