<?php
// PHP Extension Kontrolü
// JSON extension olmadan da çalışabilmeli

header('Content-Type: text/html; charset=utf-8');

$extensions = [
    'json' => extension_loaded('json'),
    'mysqli' => extension_loaded('mysqli'),
    'mbstring' => extension_loaded('mbstring'),
];

$functions = [
    'json_encode' => function_exists('json_encode'),
    'json_decode' => function_exists('json_decode'),
    'mysqli_connect' => function_exists('mysqli_connect'),
];

$all_ok = true;
$missing = [];

foreach ($extensions as $ext => $loaded) {
    if (!$loaded) {
        $all_ok = false;
        $missing[] = "Extension: $ext";
    }
}

foreach ($functions as $func => $exists) {
    if (!$exists) {
        $all_ok = false;
        $missing[] = "Function: $func";
    }
}

// HTML olarak göster (JSON extension olmadan da çalışsın)
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>PHP Extension Kontrolü</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; background: #f5f5f5; }
        .container { max-width: 800px; margin: 0 auto; background: white; padding: 20px; border-radius: 8px; box-shadow: 0 2px 4px rgba(0,0,0,0.1); }
        h1 { color: #333; }
        .status { padding: 10px; margin: 10px 0; border-radius: 4px; }
        .ok { background: #d4edda; color: #155724; border: 1px solid #c3e6cb; }
        .error { background: #f8d7da; color: #721c24; border: 1px solid #f5c6cb; }
        .info { background: #d1ecf1; color: #0c5460; border: 1px solid #bee5eb; }
        table { width: 100%; border-collapse: collapse; margin: 20px 0; }
        th, td { padding: 12px; text-align: left; border-bottom: 1px solid #ddd; }
        th { background-color: #f8f9fa; font-weight: bold; }
        .yes { color: green; font-weight: bold; }
        .no { color: red; font-weight: bold; }
    </style>
</head>
<body>
    <div class="container">
        <h1>🔍 PHP Extension Kontrolü</h1>
        
        <?php if ($all_ok): ?>
            <div class="status ok">
                <strong>✓ Başarılı:</strong> Tüm gerekli extension'lar yüklü!
            </div>
        <?php else: ?>
            <div class="status error">
                <strong>✗ Hata:</strong> Eksik extension'lar var!
            </div>
        <?php endif; ?>
        
        <div class="status info">
            <strong>PHP Versiyonu:</strong> <?php echo phpversion(); ?>
        </div>
        
        <h2>Extension Durumu</h2>
        <table>
            <tr>
                <th>Extension</th>
                <th>Durum</th>
            </tr>
            <?php foreach ($extensions as $ext => $loaded): ?>
            <tr>
                <td><?php echo htmlspecialchars($ext); ?></td>
                <td>
                    <?php if ($loaded): ?>
                        <span class="yes">✓ Yüklü</span>
                    <?php else: ?>
                        <span class="no">✗ Yüklü Değil</span>
                    <?php endif; ?>
                </td>
            </tr>
            <?php endforeach; ?>
        </table>
        
        <h2>Fonksiyon Durumu</h2>
        <table>
            <tr>
                <th>Fonksiyon</th>
                <th>Durum</th>
            </tr>
            <?php foreach ($functions as $func => $exists): ?>
            <tr>
                <td><?php echo htmlspecialchars($func); ?></td>
                <td>
                    <?php if ($exists): ?>
                        <span class="yes">✓ Mevcut</span>
                    <?php else: ?>
                        <span class="no">✗ Mevcut Değil</span>
                    <?php endif; ?>
                </td>
            </tr>
            <?php endforeach; ?>
        </table>
        
        <?php if (!empty($missing)): ?>
            <h2>⚠️ Eksik Olanlar</h2>
            <ul>
                <?php foreach ($missing as $item): ?>
                    <li><?php echo htmlspecialchars($item); ?></li>
                <?php endforeach; ?>
            </ul>
            
            <div class="status error">
                <h3>Çözüm:</h3>
                <ol>
                    <li>Hosting panelinize giriş yapın</li>
                    <li>PHP ayarlarına gidin</li>
                    <li>JSON extension'ını aktifleştirin</li>
                    <li>Veya hosting sağlayıcınızla iletişime geçin</li>
                </ol>
            </div>
        <?php endif; ?>
        
        <?php if (function_exists('json_encode')): ?>
            <h2>JSON Test (JSON Extension Varsa)</h2>
            <pre style="background: #f8f9fa; padding: 15px; border-radius: 4px; overflow-x: auto;">
<?php
echo json_encode([
    'success' => $all_ok,
    'message' => $all_ok ? 'Tüm gerekli extension\'lar yüklü' : 'Eksik extension\'lar var',
    'extensions' => $extensions,
    'functions' => $functions,
    'missing' => $missing,
    'php_version' => phpversion(),
], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
?>
            </pre>
        <?php endif; ?>
    </div>
</body>
</html>

