<?php
// Hata raporlamayı kapat (production için)
error_reporting(E_ALL);
ini_set('display_errors', 0); // HTML çıktısını önlemek için

// JSON extension kontrolü - Hem json_encode hem json_decode kontrolü
// Önce extension_loaded kontrolü, sonra function_exists kontrolü
$json_extension_loaded = extension_loaded('json');
$json_encode_exists = function_exists('json_encode');
$json_decode_exists = function_exists('json_decode');

// JSON extension yüklü mü veya fonksiyonlar mevcut mu kontrol et
if (!$json_extension_loaded && (!$json_encode_exists || !$json_decode_exists)) {
    header('Content-Type: text/plain; charset=utf-8');
    http_response_code(500);
    $missing = [];
    if (!$json_extension_loaded) $missing[] = 'json extension';
    if (!$json_encode_exists) $missing[] = 'json_encode()';
    if (!$json_decode_exists) $missing[] = 'json_decode()';
    echo '{"success":false,"message":"PHP JSON extension yüklü değil. Eksik: ' . implode(', ', $missing) . '. Lütfen hosting sağlayıcınızla iletişime geçin ve PHP JSON extension\'ını aktifleştirmelerini isteyin."}';
    exit();
}

// Eğer extension yüklü ama fonksiyonlar yoksa (nadir durum)
if ($json_extension_loaded && (!$json_encode_exists || !$json_decode_exists)) {
    // Extension yüklü ama fonksiyonlar yok - bu garip bir durum
    // Yine de devam etmeyi deneyelim, belki farklı bir şekilde yüklenmiştir
}

// Veritabanı bağlantı bilgileri
$sname = "193.111.77.77"; // sunucu
$uname = "bayrakt1_lavas"; // kullanıcı adı
$password = "]zXd%n-bP,QXL.~s"; // şifre
$db_name = "bayrakt1_proje1kisisel"; // veritabanı adı

// CORS headers (React Native için) - EN BAŞTA
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');
header('Content-Type: application/json; charset=utf-8');

// OPTIONS request için
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Veritabanı bağlantısı
$conn = new mysqli($sname, $uname, $password, $db_name);

// Bağlantı hatası kontrolü
if ($conn->connect_error) {
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode([
        'success' => false,
        'message' => 'Veritabanı bağlantı hatası: ' . $conn->connect_error
    ], JSON_UNESCAPED_UNICODE);
    exit();
}

// UTF-8 karakter seti
$conn->set_charset("utf8mb4");

// JSON input almak için
function getJsonInput() {
    // Bu fonksiyon çağrılmadan önce zaten JSON extension kontrolü yapıldı
    // Ama yine de güvenlik için kontrol edelim
    if (!function_exists('json_decode')) {
        header('Content-Type: text/plain; charset=utf-8');
        http_response_code(500);
        echo '{"success":false,"message":"PHP JSON extension yüklü değil. json_decode() fonksiyonu bulunamadı. Lütfen hosting sağlayıcınızla iletişime geçin."}';
        exit();
    }
    
    $json = file_get_contents('php://input');
    if ($json === false || empty($json)) {
        return null;
    }
    
    $decoded = json_decode($json, true);
    if (json_last_error() !== JSON_ERROR_NONE) {
        header('Content-Type: application/json; charset=utf-8');
        http_response_code(400);
        // json_encode kullanabiliriz çünkü extension kontrolü yapıldı
        echo json_encode([
            'success' => false,
            'message' => 'Geçersiz JSON formatı: ' . json_last_error_msg()
        ], JSON_UNESCAPED_UNICODE);
        exit();
    }
    
    return $decoded;
}

// Güvenli string temizleme
function sanitize($data) {
    global $conn;
    return mysqli_real_escape_string($conn, trim($data));
}

// JSON response gönderme
function sendResponse($success, $message, $data = null) {
    // Header'ları tekrar ayarla (güvenlik için)
    header('Content-Type: application/json; charset=utf-8');
    
    $response = [
        'success' => $success,
        'message' => $message
    ];
    if ($data !== null) {
        $response['data'] = $data;
    }
    
    // JSON encode kontrolü
    $json = json_encode($response, JSON_UNESCAPED_UNICODE);
    if ($json === false) {
        // JSON encode hatası
        header('Content-Type: application/json; charset=utf-8');
        echo json_encode([
            'success' => false,
            'message' => 'JSON encode hatası: ' . json_last_error_msg()
        ], JSON_UNESCAPED_UNICODE);
        exit();
    }
    
    echo $json;
    exit();
}
?>

