<?php
// Detaylı PHP Extension Kontrolü
header('Content-Type: text/html; charset=utf-8');

// Tüm extension'ları listele
$all_extensions = get_loaded_extensions();

// Kontrol edilecek extension'lar
$required_extensions = ['json', 'mysqli', 'mbstring'];
$required_functions = ['json_encode', 'json_decode', 'mysqli_connect'];

?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Detaylı PHP Extension Kontrolü</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; background: #f5f5f5; }
        .container { max-width: 1000px; margin: 0 auto; background: white; padding: 20px; border-radius: 8px; box-shadow: 0 2px 4px rgba(0,0,0,0.1); }
        h1 { color: #333; }
        .status { padding: 15px; margin: 15px 0; border-radius: 4px; }
        .ok { background: #d4edda; color: #155724; border: 1px solid #c3e6cb; }
        .error { background: #f8d7da; color: #721c24; border: 1px solid #f5c6cb; }
        .info { background: #d1ecf1; color: #0c5460; border: 1px solid #bee5eb; }
        .warning { background: #fff3cd; color: #856404; border: 1px solid #ffeaa7; }
        table { width: 100%; border-collapse: collapse; margin: 20px 0; }
        th, td { padding: 12px; text-align: left; border-bottom: 1px solid #ddd; }
        th { background-color: #f8f9fa; font-weight: bold; }
        .yes { color: green; font-weight: bold; }
        .no { color: red; font-weight: bold; }
        .code { background: #f8f9fa; padding: 2px 6px; border-radius: 3px; font-family: monospace; }
    </style>
</head>
<body>
    <div class="container">
        <h1>🔍 Detaylı PHP Extension Kontrolü</h1>
        
        <div class="status info">
            <strong>PHP Versiyonu:</strong> <?php echo phpversion(); ?><br>
            <strong>Toplam Yüklü Extension Sayısı:</strong> <?php echo count($all_extensions); ?>
        </div>
        
        <h2>1. Gerekli Extension Kontrolü</h2>
        <table>
            <tr>
                <th>Extension</th>
                <th>extension_loaded()</th>
                <th>get_loaded_extensions()</th>
                <th>Durum</th>
            </tr>
            <?php
            $all_ok = true;
            foreach ($required_extensions as $ext):
                $loaded_via_function = extension_loaded($ext);
                $loaded_via_list = in_array($ext, $all_extensions);
                $is_ok = $loaded_via_function || $loaded_via_list;
                if (!$is_ok) $all_ok = false;
            ?>
            <tr>
                <td><span class="code"><?php echo htmlspecialchars($ext); ?></span></td>
                <td><?php echo $loaded_via_function ? '<span class="yes">✓ TRUE</span>' : '<span class="no">✗ FALSE</span>'; ?></td>
                <td><?php echo $loaded_via_list ? '<span class="yes">✓ VAR</span>' : '<span class="no">✗ YOK</span>'; ?></td>
                <td>
                    <?php if ($is_ok): ?>
                        <span class="yes">✓ Yüklü</span>
                    <?php else: ?>
                        <span class="no">✗ Yüklü Değil</span>
                    <?php endif; ?>
                </td>
            </tr>
            <?php endforeach; ?>
        </table>
        
        <h2>2. Gerekli Fonksiyon Kontrolü</h2>
        <table>
            <tr>
                <th>Fonksiyon</th>
                <th>function_exists()</th>
                <th>Durum</th>
            </tr>
            <?php
            foreach ($required_functions as $func):
                $exists = function_exists($func);
                if (!$exists) $all_ok = false;
            ?>
            <tr>
                <td><span class="code"><?php echo htmlspecialchars($func); ?>()</span></td>
                <td><?php echo $exists ? '<span class="yes">✓ TRUE</span>' : '<span class="no">✗ FALSE</span>'; ?></td>
                <td>
                    <?php if ($exists): ?>
                        <span class="yes">✓ Mevcut</span>
                    <?php else: ?>
                        <span class="no">✗ Mevcut Değil</span>
                    <?php endif; ?>
                </td>
            </tr>
            <?php endforeach; ?>
        </table>
        
        <h2>3. JSON Extension Detaylı Test</h2>
        <div class="status <?php echo function_exists('json_encode') && function_exists('json_decode') ? 'ok' : 'error'; ?>">
            <?php if (function_exists('json_encode') && function_exists('json_decode')): ?>
                <strong>✓ JSON Fonksiyonları Çalışıyor!</strong><br>
                <?php
                // Test JSON encode/decode
                $test_data = ['test' => 'value', 'number' => 123];
                $encoded = json_encode($test_data);
                $decoded = json_decode($encoded, true);
                
                if ($decoded && $decoded['test'] === 'value') {
                    echo "✓ json_encode() test: BAŞARILI<br>";
                    echo "✓ json_decode() test: BAŞARILI<br>";
                    echo "✓ Test verisi: " . htmlspecialchars($encoded);
                } else {
                    echo "⚠ json_encode/decode test: BAŞARISIZ";
                }
                ?>
            <?php else: ?>
                <strong>✗ JSON Fonksiyonları Çalışmıyor!</strong><br>
                json_encode(): <?php echo function_exists('json_encode') ? 'VAR' : 'YOK'; ?><br>
                json_decode(): <?php echo function_exists('json_decode') ? 'VAR' : 'YOK'; ?>
            <?php endif; ?>
        </div>
        
        <h2>4. Tüm Yüklü Extension'lar (İlk 50)</h2>
        <div class="status info">
            <strong>Toplam:</strong> <?php echo count($all_extensions); ?> extension yüklü
        </div>
        <div style="display: grid; grid-template-columns: repeat(auto-fill, minmax(200px, 1fr)); gap: 10px; margin: 20px 0;">
            <?php
            $displayed = 0;
            foreach ($all_extensions as $ext):
                if ($displayed++ >= 50) break;
                $is_required = in_array($ext, $required_extensions);
                $style = $is_required ? 'background: #d4edda; padding: 5px; border-radius: 3px;' : 'padding: 5px;';
            ?>
                <div style="<?php echo $style; ?>">
                    <span class="code"><?php echo htmlspecialchars($ext); ?></span>
                    <?php if ($is_required): ?><strong> (Gerekli)</strong><?php endif; ?>
                </div>
            <?php endforeach; ?>
        </div>
        
        <?php if ($all_ok): ?>
            <div class="status ok">
                <h2>✓ Sonuç: Tüm Gerekli Extension'lar Yüklü!</h2>
                <p>Eğer hala hata alıyorsanız, sorun extension'larda değil, başka bir yerde olabilir.</p>
            </div>
        <?php else: ?>
            <div class="status error">
                <h2>✗ Sonuç: Eksik Extension'lar Var</h2>
                <p>Lütfen hosting sağlayıcınızla iletişime geçin.</p>
            </div>
        <?php endif; ?>
        
        <h2>5. PHP Yapılandırması</h2>
        <div class="status warning">
            <strong>php.ini Yolu:</strong> <?php echo php_ini_loaded_file() ?: 'Bilinmiyor'; ?><br>
            <strong>Extension Dizini:</strong> <?php echo ini_get('extension_dir') ?: 'Bilinmiyor'; ?>
        </div>
    </div>
</body>
</html>

