-- Kullanıcı susturma tablosu
CREATE TABLE IF NOT EXISTS `user_mutes` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `user_id` INT(11) NOT NULL COMMENT 'Susturan kullanıcı',
  `muted_user_id` INT(11) NOT NULL COMMENT 'Susturulan kullanıcı',
  `mute_until` DATETIME NULL COMMENT 'Susturma bitiş zamanı (NULL ise süresiz)',
  `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_user_mute` (`user_id`, `muted_user_id`),
  FOREIGN KEY (`user_id`) REFERENCES `users`(`id`) ON DELETE CASCADE,
  FOREIGN KEY (`muted_user_id`) REFERENCES `users`(`id`) ON DELETE CASCADE,
  INDEX `idx_user_id` (`user_id`),
  INDEX `idx_muted_user_id` (`muted_user_id`),
  INDEX `idx_mute_until` (`mute_until`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

