<?php
// PHP bilgilerini göster (JSON extension kontrolü için)
// ÖNEMLİ: Bu dosyayı test ettikten sonra SİLİN (güvenlik riski)

// Önce JSON extension kontrolü yapalım
$json_available = function_exists('json_encode') && function_exists('json_decode');
$json_extension_loaded = extension_loaded('json');

?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>PHP Info - JSON Extension Kontrolü</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; background: #f5f5f5; }
        .warning { background: #fff3cd; border: 1px solid #ffc107; padding: 15px; margin: 20px 0; border-radius: 4px; }
        .error { background: #f8d7da; border: 1px solid #dc3545; padding: 15px; margin: 20px 0; border-radius: 4px; }
        .success { background: #d4edda; border: 1px solid #28a745; padding: 15px; margin: 20px 0; border-radius: 4px; }
        .info-box { background: white; padding: 20px; border-radius: 8px; margin: 20px 0; box-shadow: 0 2px 4px rgba(0,0,0,0.1); }
    </style>
</head>
<body>
    <div class="info-box">
        <h1>🔍 JSON Extension Kontrolü</h1>
        
        <?php if ($json_available && $json_extension_loaded): ?>
            <div class="success">
                <strong>✓ JSON Extension Yüklü!</strong><br>
                json_encode() fonksiyonu: VAR ✓<br>
                json_decode() fonksiyonu: VAR ✓<br>
                JSON extension yüklü mü: EVET ✓
            </div>
        <?php else: ?>
            <div class="error">
                <strong>✗ JSON Extension Yüklü Değil!</strong><br>
                json_encode() fonksiyonu: <?php echo function_exists('json_encode') ? 'VAR ✓' : 'YOK ✗'; ?><br>
                json_decode() fonksiyonu: <?php echo function_exists('json_decode') ? 'VAR ✓' : 'YOK ✗'; ?><br>
                JSON extension yüklü mü: <?php echo extension_loaded('json') ? 'EVET ✓' : 'HAYIR ✗'; ?>
            </div>
        <?php endif; ?>
        
        <div class="warning">
            <strong>⚠️ Güvenlik Uyarısı:</strong> Bu dosyayı test ettikten sonra SİLİN! (phpinfo() güvenlik riski oluşturabilir)
        </div>
    </div>
    
    <?php
    // phpinfo() göster (sadece JSON extension varsa JSON formatında da göster)
    phpinfo();
    ?>
</body>
</html>

